package ypclient

import (
	"context"

	"a.yandex-team.ru/yp/go/proto/ypapi"
)

type YpPod struct {
	Cluster string
	Pod     ypapi.TPod
}

type YpClientInterface interface {
	GetClusters() []string
	ListPods(ctx context.Context, podSetID string) (pods []*YpPod, err error)
	FindPod(ctx context.Context, podID string, clusters ...string) (pod *YpPod, err error)
	SelectHQSyncerPods(ctx context.Context) (pods []*YpPod, err error)
	SetPodLabel(ctx context.Context, cluster string, id string, key string, value []byte) error
	ListServicePods(ctx context.Context, serviceID string) ([]*YpPod, error)
}
