package ypclient

import (
	"context"
	"github.com/stretchr/testify/assert"
	"os"
	"testing"
)

func TestYpClient_FindPod(t *testing.T) {
	if _, ok := os.LookupEnv("YP_TOKEN"); !ok {
		t.Skipf("YP_TOKEN not found in environ, skip test")
	}

	ypClient, error := NewYpClient([]string{"sas", "man", "vla", "iva", "myt"}, 200)
	assert.NoError(t, error)

	podCandidate, error := ypClient.FindPod(context.TODO(), "deploy-export-stats-1", "sas", "man")
	assert.NoError(t, error)
	assert.NotNil(t, podCandidate)

	podCandidate2, error2 := ypClient.FindPod(context.TODO(), "deploy-export-stats-1", "iva")
	assert.NoError(t, error2)
	assert.Nil(t, podCandidate2)

	_, error3 := ypClient.FindPod(context.TODO(), "deploy-export-stats-1", "sas-test")
	assert.Error(t, error3)
}

func TestYpClient_ListPods(t *testing.T) {
	if _, ok := os.LookupEnv("YP_TOKEN"); !ok {
		t.Skipf("YP_TOKEN not found in environ, skip test")
	}

	ypClient, error := NewYpClient([]string{"sas", "man", "vla", "iva", "myt"}, 200)
	assert.NoError(t, error)

	pods, error := ypClient.ListPods(context.TODO(), "deploy-export-stats")
	assert.NoError(t, error)
	assert.Len(t, pods, 3)
}
