import logging
import traceback
import sys

from infra.netconfig.lib import stateutil
from infra.netconfig.lib import jugglerutil
from infra.netconfig.lib import master

SERVICE_NAME = "netconfig_state_intergrity"


def run(iface_name=None, iface_state=None):
    states = []
    if iface_state:
        states.append((iface_name, iface_state))
    else:
        for iface_name in master.get_configured_interfaces():
            states.append((iface_name, master.get_state(iface_name)))

    if not states:
        jugglerutil.push_local(
            'CRIT',
            "No configured interfaces found",
            SERVICE_NAME,
            ['no_configured_ifaces'],
        )
        return

    for iface_name, iface_state in states:
        try:
            stateutil.verify_state(iface_name, iface_state)
        except master.NetconfigError as e:
            logging.error("State check: %s" % e.message)
            jugglerutil.push_local(
                'CRIT',
                e.message,
                SERVICE_NAME,
                ['check_netconfig_exception'],
            )
            return
        except Exception as e:
            logging.exception("Check exception:")
            jugglerutil.push_local(
                'CRIT',
                "state_integrity check failed: %s" % "\n".join(
                    traceback.format_exception(*sys.exc_info())
                ),
                SERVICE_NAME,
                ['check_exception'],
            )
            return

    jugglerutil.push_local(
        'OK',
        "",
        SERVICE_NAME,
        ['OK'],
    )
