import subprocess
from infra.netconfig.lib import master


class DeviceHack:
    def ensure(self):
        return False

    def apply(self):
        return True

    def name(self):
        return ""


def get_adapter_pcid(iface_name):
    vendor_id = None
    device_id = None

    try:
        vendor_id = open("/sys/class/net/%s/device/vendor" % iface_name).read().split()[0]
        device_id = open("/sys/class/net/%s/device/device" % iface_name).read().split()[0]
    except IOError:
        return (None, None)

    if not vendor_id or not device_id:
        return (None, None)

    return (vendor_id, device_id)


class MlxMt27710RxhashOff(DeviceHack):
    def name(self):
        return "mlx_mt27710_rxhash_off"

    def ensure(self):
        ifaces = master.get_configured_interfaces()

        if (
            not open("/proc/sys/kernel/ostype").read().startswith("Linux") or
            not open("/proc/sys/kernel/osrelease").read().startswith("4.4.")
        ):
            return False

        for iface_name in ifaces:
            if get_adapter_pcid(iface_name) == ("0x15b3", "0x1015"):
                try:
                    ethtool = subprocess.check_output(["ethtool", "-k", iface_name])
                    for line in ethtool.splitlines():
                        if "receive-hashing" in line and "on" in line:
                            return True
                except:
                    pass

        return False

    def apply(self):
        result = False
        ifaces = master.get_configured_interfaces()

        for iface_name in ifaces:
            if get_adapter_pcid(iface_name) == ("0x15b3", "0x1015"):
                try:
                    subprocess.check_call(["ethtool", "-K", iface_name, "rxhash", "off"])
                    result = True
                except:
                    result = False

        return result
