import requests
import logging

from socket import gethostname
from requests.adapters import HTTPAdapter
from requests.packages.urllib3.util.retry import Retry
from infra.netconfig.lib import master

TIMEOUT = 5.0
RETRY_LIMIT = 5


def push_local(status, desc, service, tags):

    # FIXME: Looks like here can be issue, when we configure more than one interface
    ifaces = master.get_configured_interfaces()
    project_id = 'empty'
    for iface_name in ifaces:
        iface_obj = master.DebianInterfaces().get_iface_definitions(iface_name)[0]
        try:
            project_id = master.get_project_id(iface_obj, silent=False)
        except Exception:
            logging.info('Could not get project id')
        break

    tags.extend(('yandex-netconfig', '_'.join(('prj_id', str(project_id)))))
    events = {
        "events": [
            {
                "host": gethostname(),
                "service": service,
                "instance": "",
                "status": status,
                "description": desc,
                "tags": tags,
            }
        ]
    }
    try:
        with requests.Session() as s:
            retries = Retry(
                total=RETRY_LIMIT,
                read=RETRY_LIMIT,
                connect=RETRY_LIMIT,
                backoff_factor=0.5,
                status_forcelist=[500, 502, 503, 504],
                method_whitelist=frozenset(['POST'])
            )
            s.mount('http://', HTTPAdapter(max_retries=retries))
            s.post("http://[::1]:31579/events", json=events, timeout=TIMEOUT)
    except Exception:
        logging.error("juggler request failed")
