import requests
import logging

from requests.adapters import HTTPAdapter
from requests.packages.urllib3.util.retry import Retry

TIMEOUT = 10.0
RETRY_LIMIT = 5


def push_local(signal_values):
    values = []
    signals = {
        "tags": {
            "itype": "runtimecloud",
            "ctype": "production",
        },
        "values": values,
        "ttl": 7200,
    }
    for name, value in signal_values:
        values.append(
            {
                "name": name,
                "val": value
            }
        )
    try:
        with requests.Session() as s:
            retries = Retry(
                total=RETRY_LIMIT,
                read=RETRY_LIMIT,
                connect=RETRY_LIMIT,
                backoff_factor=0.5,
                status_forcelist=[500, 502, 503, 504],
                method_whitelist=frozenset(['POST'])
            )

            s.mount('http://', HTTPAdapter(max_retries=retries))
            r = s.post("http://[::1]:11005/", json=[signals], timeout=TIMEOUT)
            logging.info(r.text)
    except Exception:
        logging.error("golovan request failed")
