import argparse
import sys
from infra.netconfig.utils.pinger.lib import master


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('-s', dest='sleep', default=16, help='Set sleeping time.')
    parser.add_argument('-r', '--remote-container-ip', dest='remote_container_ip', help='Remote container IP to test.')
    parser.add_argument('-c', dest='client_mode', action='store_true', help='Run client only')
    return parser.parse_args()


def main():
    args = parse_args()
    if args.client_mode:
        client_ip = master.form_ip_for_container()
        master.run_client(client_ip, args.sleep, wait_for_dead=True)
        sys.exit()

    master.run_master(args.remote_container_ip, args.sleep)


if __name__ == '__main__':
    main()
