#pragma once

#include "syncqueue.h"

#include <library/cpp/deprecated/atomic/atomic.h>
#include <library/cpp/netliba/v12/block_chain.h>
#include <library/cpp/netliba/v12/udp_host.h>
#include <library/cpp/netliba/v12/udp_address.h>
#include <library/cpp/cache/cache.h>

#include <util/generic/ptr.h>
#include <util/generic/deque.h>
#include <util/system/event.h>
#include <util/thread/lfqueue.h>
#include <util/thread/factory.h>


class TBusResolveError : public yexception {
    public:
        TBusResolveError(int code);

        int code;
};

class TMsgBus {
public:
    TMsgBus(int port=0, float timeout=15.0f);
    ~TMsgBus();

    enum ESendResult {
        Ok,
        Retried,
        Failed,
        Unknown
    };

    struct TransferState {
        bool HasOut;
        size_t In;
        size_t Transfers;
    };

    struct RecvMsg {
        TString Data;
        TString Address;
        TString MyAddress;
    };

    typedef void(*TSendResultCallback)(void * /*obj*/, TString /*dest*/, TString /*addr*/, ESendResult /*result*/);

    void Start();
    void Stop();
    void Send(TString msg, TString addr, TString dest_host);
    void Send(TString msg, const TDeque<NNetliba_v12::TUdpAddress>& addrs, TString dest_host);
    RecvMsg Receive(bool block = true, double timeout = .0);
    int GetListenPort();
    void SetSendResultCallback(void *cookie, TSendResultCallback cb);
    TransferState GetTransferState();

private:
    class TLoop : public IThreadFactory::IThreadAble {
    public:
        TLoop(TMsgBus& bus);
        virtual ~TLoop();

        void Start();
        void Stop();

    private:
        void DoExecute();

        TAtomic Running;
        TManualEvent Started;

        TMsgBus& Bus;
        TAutoPtr<IThreadFactory::IThread> Thread;
    } Loop;

    void SendMessages();
    void RecvMessages();
    void ProcessSendResults();

    using TConnectionPtr = TIntrusivePtr<NNetliba_v12::IConnection>;
    TConnectionPtr GetConnection(const NNetliba_v12::TUdpAddress &address);

    struct TSendMsg {
        TString data;
        TDeque<NNetliba_v12::TUdpAddress> addresses;
        TString dest_host;
    };

    using TRecvMsg = std::tuple<TString, NNetliba_v12::TUdpAddress, NNetliba_v12::TUdpAddress>;
    TLockFreeQueue<TSendMsg> SendQueue;
    TSyncQueue<TRecvMsg> RecvQueue;

    TIntrusivePtr<NNetliba_v12::IUdpHost> UdpHost;
    TIntrusivePtr<NNetlibaSocket::ISocket> Socket;
    TLRUCache<NNetliba_v12::TUdpAddress, TConnectionPtr> Connections;
    THashMap<NNetliba_v12::TTransfer, TSendMsg> Transfers;

    TSendResultCallback ResultCallback;
    void *ResultCallbackObj;
};
