#include <util/generic/yexception.h>

#include "Python.h"
#include "errors.h"
#include <infra/netlibus/msgbus.h>
#include <infra/netlibus/syncqueue.h>

extern PyObject *TimeoutError;
extern PyObject *ResolveError;

void RaisePyError() {
    try {
        throw;
    } catch (TSyncQueueTimeout &) {
        PyErr_SetString(TimeoutError, "Receive queue is empty");
    } catch (TBusResolveError &e) {
        PyObject *v = Py_BuildValue("(is)", e.code, gai_strerror(e.code));
        PyErr_SetObject(ResolveError, v);
        Py_DECREF(v);
    } catch (const std::exception &e) {
        PyErr_SetString(PyExc_RuntimeError, e.what());
    }
}
