# coding: utf-8
"""This module declare extern function that should be used for logging from native modules.

Remember, that logging will be performed from separate thread.
"""

import logging
from cpython.ref cimport PyObject


cdef extern from "Python.h":
    cdef void PyEval_InitThreads()


cdef extern from "library/cpp/logger/priority.h" nogil:
    cdef enum ELogPriority:
        TLOG_EMERG       # = 0,
        TLOG_ALERT       # = 1,
        TLOG_CRIT        # = 2,
        TLOG_ERR         # = 3,
        TLOG_WARNING     # = 4,
        TLOG_NOTICE      # = 5,
        TLOG_INFO        # = 6,
        TLOG_DEBUG       # = 7,
        TLOG_RESOURCES   # = 8


cdef int _to_python_log_level(int level):
    if level == TLOG_EMERG or level == TLOG_ALERT or level == TLOG_CRIT:
        return logging.CRITICAL
    elif level == TLOG_ERR:
        return logging.ERROR
    elif level == TLOG_WARNING:
        return logging.WARNING
    elif level == TLOG_NOTICE or level == TLOG_INFO:
        return logging.INFO
    else:
        return logging.DEBUG


cdef public api void _logger_callback_thunk(PyObject* obj, const char* data, size_t length, int level) with gil:
    cdef object message = data[:length]
    (<object>obj).log(_to_python_log_level(level), message.rstrip())


PyEval_InitThreads()
