# coding: utf-8
from __future__ import print_function

# always import this module to initliaze logger callback properly
import _logger_callback  # noqa

import monotonic
import tornado.ioloop
import tornado.httpclient
import tornado.netutil
from requests.certs import where

import _netmon

from . import const


def init():
    # initialize TUnistat
    _netmon.init_metrics()

    # configure tornado
    tornado.ioloop.IOLoop.configure(None, time_func=monotonic.monotonic)
    tornado.netutil.Resolver.configure("agent.application.FallbackResolver")
    tornado.httpclient.AsyncHTTPClient.configure(
        "tornado.simple_httpclient.SimpleAsyncHTTPClient",
        max_clients=128,
        defaults=dict(user_agent="netmon-agent/{}".format(const.VERSION),
                      validate_cert=True,
                      ca_certs=where(),
                      request_timeout=30.0,
                      connect_timeout=5.0))
