# coding: utf-8
from __future__ import print_function

import contextlib

import tornado.ioloop
import tornado.concurrent


def defer(method, *args):
    """Convert bindings callbacks into future."""
    future = tornado.concurrent.Future()

    def inner_callback(result, error):
        if error is None:
            future.set_result(result)
        else:
            future.set_exception(Exception(error))

    def thread_safe_wrapper(result, error):
        tornado.ioloop.IOLoop.current().add_callback(inner_callback, result, error)

    method(thread_safe_wrapper, *args)

    return future


@contextlib.contextmanager
def context(controller):
    controller.start()
    try:
        yield controller
    finally:
        controller.stop()
