# coding: utf-8
from __future__ import print_function

import tornado.gen

from . import planner
from . import system


@tornado.gen.coroutine
def diagnostic_task(task, arguments, result):
    result.Arguments.CopyFrom(arguments)

    system_info_collector = system.SystemInfoCollector(result, on_changed=task.report)
    probe_planner = planner.ProbePlanner(task.app, arguments, result, on_changed=task.report)

    try:
        yield probe_planner.run()
    finally:
        yield system_info_collector.cancel()

    raise tornado.gen.Return(result)
