# -*- coding: utf-8 -*-
"""Utils to work with `str` and `unicode` objects and convert them properly.
Provides functions that can safely work with strings without `UnicodeDecodeError`.
Treat all raw strings as UTF-8.

"""

from __future__ import absolute_import

import traceback

__all__ = ['safe_repr', 'safe_str', 'safe_unicode']

# TODO: should we respect sys.get*encoding?
DEFAULT_ENCODING = 'utf-8'
DEFAULT_ERRORS = 'replace'


def _format_exc(o, exc):
    return b'<Unrepresentable {0!r}: {1!r} {2!r}>'.format(
        type(o), exc, b'\n'.join(traceback.format_stack()))


def safe_repr(o):
    try:
        return repr(o)
    except Exception as exc:
        return _format_exc(o, exc)


def _safe_str(s, errors=DEFAULT_ERRORS, encoding=DEFAULT_ENCODING):
    try:
        if isinstance(s, unicode):
            return s.encode(encoding, errors)
        return s
    except Exception as exc:
        return _format_exc(s, exc)


def safe_str(s, errors=DEFAULT_ERRORS, encoding=DEFAULT_ENCODING):
    if not isinstance(s, (unicode, str)):
        try:
            return str(s)
        except Exception as exc:
            return _format_exc(s, exc)
    return _safe_str(s, errors, encoding)


def _safe_unicode(s, errors=DEFAULT_ERRORS, encoding=DEFAULT_ENCODING):
    try:
        if isinstance(s, unicode):
            return s
        return unicode(s, encoding, errors)
    except Exception as exc:
        return _format_exc(s, exc)


def safe_unicode(s, errors=DEFAULT_ERRORS, encoding=DEFAULT_ENCODING):
    if not isinstance(s, (unicode, str)):
        try:
            # TODO: support __unicode__ protocol properly
            s = str(s)
        except Exception as exc:
            s = _format_exc(s, exc)
    return _safe_unicode(s, errors, encoding)
