# coding: utf-8
from __future__ import print_function


class AgentError(Exception):
    """All agent exceptions should be derived from it."""
    pass


class ValidationError(AgentError):
    """Raised in case invalid data."""
    pass


class RetryError(AgentError):
    """Raised if ticker should retry loop with some growing delay."""
    pass


class GroupNotReady(RetryError):
    """Raised if specified group isn't cached yet."""

    def __init__(self, group_name):
        self.group_name = group_name
        super(GroupNotReady, self).__init__(
            "Group {} is not ready".format(group_name)
        )


class TasksNotSaved(RetryError):
    """Raised if tasks can't be saved by server."""
    pass


class BackendUrlsNotReady(RetryError):
    """
    Raised when action can't be executed until BackendMaintainer
    completes initialization.
    """
    pass
