#pragma once

#include <util/network/address.h>
#include <util/generic/maybe.h>

namespace NNetmon {
    class TDnsCache : public TNonCopyable {
    public:
        using TAddrs = TVector<NAddr::IRemoteAddrRef>;

        TDnsCache();
        ~TDnsCache();

        TMaybe<TAddrs> Get(const TString& name, int port, int family) noexcept;
        void SetWithTTL(const TString& name, int port, int family, const TAddrs& addrs,
                        unsigned int ttlSecs) noexcept;
        void Set(const TString& name, int port, int family, const TAddrs& addrs) noexcept;
        void Cleanup() noexcept;

    private:
        class TImpl;
        THolder<TImpl> Impl;
    };
}
