#!/usr/bin/env python
# pylint: disable=line-too-long,missing-docstring
from __future__ import absolute_import, print_function

import os
import tempfile
import subprocess
import json

import requests


def sandbox(method, path, **kwargs):
    url = "https://sandbox.yandex-team.ru{}".format(path)
    resp = requests.request(method, url, data=json.dumps(kwargs), headers={
        "Authorization": "OAuth {}".format(os.environ["SANDBOX_OAUTH_TOKEN"]),
        "Content-Type": "application/json"
    })
    return resp.json() if resp.content else None


def main():
    patch_id = None
    data = subprocess.check_output("cd $ARCADIA_ROOT && $ARCADIA_ROOT/ya svn --detect diff infra/netmon/agent", shell=True)

    if data:
        print("Uploading and share patch")
        with tempfile.NamedTemporaryFile() as stream:
            stream.write(data)
            stream.flush()
            subprocess.check_call("scp -q {} jmon-test.search.yandex.net:netmon-agent.patch".format(stream.name), shell=True)
        patch_id = subprocess.check_output("ssh -q jmon-test.search.yandex.net sky share netmon-agent.patch", shell=True)
        patch_id = patch_id.strip()
        print("Patch id is {}".format(patch_id))

    task_id = sandbox("POST", "/api/v1.0/task", type="YA_PACKAGE", context={
        "packages": "infra/netmon/agent/bundle/agent.json",
        "package_type": "tarball",
        "checkout_arcadia_from_url": "arcadia:/arc/trunk/arcadia",
        "resource_type": "NETMON_AGENT",
        "target_platform": "DEFAULT-LINUX-X86_64",
        "build_type": "release",
        "build_system": "ya",
        "musl": True,
        "arcadia_patch": patch_id if patch_id is not None else ""
    })["id"]
    print("Task URL is https://sandbox.yandex-team.ru/task/{}/view".format(task_id))

    sandbox("PUT", "/api/v1.0/task/{}".format(task_id), owner="JUGGLER", priority={
        "class": "USER",
        "subclass": "NORMAL"
    })

    print("Task started: {}".format(sandbox("PUT", "/api/v1.0/batch/tasks/start", comment="build netmon agent", id=[task_id])))


if __name__ == "__main__":
    main()
