#pragma once

#include <util/memory/smallobj.h>

#include <array>

namespace NNetmon {
    namespace {
        const std::size_t MAX_BUFFER_SIZE = 8192;
    }

    class TOnDemandBuffer : public TNonCopyable {
    public:
        class TUnderlyingBuffer : public TObjectFromPool<TUnderlyingBuffer> {
        public:
            inline char* Data() noexcept {
                return Buf_.data();
            }

            inline std::size_t Capacity() noexcept {
                return Buf_.size();
            }

        private:
            std::array<char, MAX_BUFFER_SIZE> Buf_;
        };

        using TPool = TUnderlyingBuffer::TPool;

        TOnDemandBuffer(TPool& pool)
            : Pool_(pool)
        {
        }

        inline char* Data() noexcept {
            return GetOrCreate().Data();
        }

        inline std::size_t Capacity() noexcept {
            return GetOrCreate().Capacity();
        }

        inline void Reset() noexcept {
            Buf_.Reset();
        }

    private:
        inline TUnderlyingBuffer& GetOrCreate() noexcept {
            if (!Buf_) {
                Buf_.Reset(new (&Pool_) TUnderlyingBuffer());
            }
            return *Buf_;
        }

        TPool& Pool_;
        THolder<TUnderlyingBuffer> Buf_;
    };
}
