#include "logger.h"

#include <library/cpp/logger/record.h>
#include <library/cpp/pybind/ptr.h>

extern "C" {
    void _logger_callback_thunk(PyObject*, const char*, size_t, int);
}

class TPythonLogBackend::TImpl {
public:
    TImpl(PyObject* logger)
        : Logger(logger, false)
    {
    }

    inline void WriteData(const TLogRecord& rec) {
        _logger_callback_thunk(Logger.Get(), rec.Data, rec.Len, rec.Priority);
    }

private:
    NPyBind::TPyObjectPtr Logger;
};

TPythonLogBackend::TPythonLogBackend(PyObject* logger)
    : Impl(MakeHolder<TImpl>(logger))
{
}

TPythonLogBackend::~TPythonLogBackend()
{
}

void TPythonLogBackend::WriteData(const TLogRecord& rec) {
    Impl->WriteData(rec);
}

void TPythonLogBackend::ReopenLog() {
}

