#pragma once

#include <library/cpp/coroutine/engine/impl.h>

namespace NNetmon {
    template <typename T, void (T::*M)(TCont*)>
    class TSimpleContLoop {
    public:
        TSimpleContLoop(TContExecutor* executor, T* obj, const char* name)
            : Executor_(executor)
            , Obj_(obj)
            , Name_(name)
            , Cont_(nullptr)
        {
        }

        ~TSimpleContLoop() {
            Stop();
        }

        inline void Start() {
            if (!Cont_) {
                Cont_ = Executor_->Create<TSimpleContLoop, &TSimpleContLoop::Run>(this, Name_);
            }
        }

        inline void Run(TCont* cont) noexcept {
            Cont_ = cont;
            (Obj_->*M)(Cont_);
            Cont_ = nullptr;
        }

    private:
        inline void Stop() noexcept {
            if (Cont_) {
                Cont_->Cancel();

                while (Cont_) {
                    Executor_->Running()->Yield();
                }
            }
        }

        TContExecutor* Executor_;
        T* Obj_;
        const char* Name_;
        TCont* Cont_;
    };
}
