#pragma once

#include <library/cpp/unistat/pusher/pusher.h>

namespace NNetmon {
    enum class ESignals {
        ProbeReceiveLag,

        EchoDispatchDelay,
        EchoFlightDelay,
        EchoQueueDelay,
        EchoReceivedProbes,
        EchoSentProbes,
        EchoTruncatedProbes,
        EchoExpiredProbes,

        PacketSent,
        PacketReceived,
        PacketLost,
        PacketRoundTripDelay,
    };

    enum class EPushSignals {
        LinkRttHw,
        LinkRttSys,
        LinkRttUser,
        LinkSendInterval,

        ClockSkewSys,

        TargetDelay,

        ReportsThrottled,

        ScheduleOutdatedIps,

        ProbeOverflows,

        PacketCongested,
        PacketCorrupted,
        PacketMartian,

        DnsCacheHit,
        DnsCacheMiss,

        YpSdFails,
        DnsFails,

        AgentStarts,
    };

    inline TString ToString(const NNetmon::ESignals v) {
        switch (v) {
            case ESignals::ProbeReceiveLag:
                return "probe_receive_lag";

            case ESignals::EchoDispatchDelay:
                return "echo_dispatch_delay";
            case ESignals::EchoFlightDelay:
                return "echo_flight_delay";
            case ESignals::EchoQueueDelay:
                return "echo_queue_delay";
            case ESignals::EchoReceivedProbes:
                return "echo_received_probes";
            case ESignals::EchoSentProbes:
                return "echo_sent_probes";
            case ESignals::EchoTruncatedProbes:
                return "echo_truncated_probes";
            case ESignals::EchoExpiredProbes:
                return "echo_expired_probes";

            case ESignals::PacketSent:
                return "packet_sent";
            case ESignals::PacketReceived:
                return "packet_received";
            case ESignals::PacketLost:
                return "packet_lost";
            case ESignals::PacketRoundTripDelay:
                return "packet_round_trip_delay";
        };
    }

    inline TString ToString(const NNetmon::EPushSignals v) {
        switch (v) {
            case EPushSignals::LinkRttHw:
                return "link_rtt_hw";
            case EPushSignals::LinkRttSys:
                return "link_rtt_sys";
            case EPushSignals::LinkRttUser:
                return "link_rtt_user";
            case EPushSignals::LinkSendInterval:
                return "link_send_interval";

            case EPushSignals::ClockSkewSys:
                return "clock_skew_sys";

            case EPushSignals::TargetDelay:
                return "target_delay";

            case EPushSignals::ReportsThrottled:
                return "reports_throttled";

            case EPushSignals::ScheduleOutdatedIps:
                return "schedule_outdated_ips";

            case EPushSignals::ProbeOverflows:
                return "probe_overflows";

            case EPushSignals::PacketCongested:
                return "packet_congested";
            case EPushSignals::PacketCorrupted:
                return "packet_corrupted";
            case EPushSignals::PacketMartian:
                return "packet_martian";

            case EPushSignals::DnsCacheHit:
                return "dns_cache_hit";
            case EPushSignals::DnsCacheMiss:
                return "dns_cache_miss";

            case EPushSignals::YpSdFails:
                return "yp_sd_fails";
            case EPushSignals::DnsFails:
                return "dns_fails";

            case EPushSignals::AgentStarts:
                return "agent_starts";
        }
    }

    const TVector<double>& GetBucketWeights();

    void InitUnistat();

    void StartUnistatPusher();
    void StopUnistatPusher();

    inline void PushSignal(const NNetmon::EPushSignals hole, double signal) {
        TUnistatPusher::Instance().PushSignalUnsafe(hole, signal);
    }
}
