#pragma once

#include <util/generic/singleton.h>

namespace NNetmon {
    class TSettings {
    public:
        // Any TSettings object refers to the same TSettingsStruct.
        // Needed for Python bindings.
        TSettings()
            : SettingsStruct(SingletonWithPriority<TSettingsStruct, 100000>())
        {}

        bool GetCheckFullTypeOfService() const {
            return SettingsStruct->CheckFullTypeOfService;
        }
        void SetCheckFullTypeOfService(bool& value) {
            SettingsStruct->CheckFullTypeOfService = value;
        }

        bool GetFixReplyTypeOfService() const {
            return SettingsStruct->FixReplyTypeOfService;
        }
        void SetFixReplyTypeOfService(bool& value) {
            SettingsStruct->FixReplyTypeOfService = value;
        }

        bool GetUseHwTimestamps() const {
            return SettingsStruct->UseHwTimestamps;
        }
        void SetUseHwTimestamps(bool& value) {
            SettingsStruct->UseHwTimestamps = value;
        }

        size_t GetUdpSocketCount() const {
            return SettingsStruct->UdpSocketCount;
        }
        void SetUdpSocketCount(size_t& value) {
            SettingsStruct->UdpSocketCount = value;
        }

        size_t GetPacketSize() const {
            return SettingsStruct->PacketSize;
        }
        void SetPacketSize(size_t& value) {
            SettingsStruct->PacketSize = value;
        }

        size_t GetLinkPollerPacketSize() const {
            return SettingsStruct->LinkPollerPacketSize;
        }
        void SetLinkPollerPacketSize(size_t& value) {
            SettingsStruct->LinkPollerPacketSize = value;
        }

        bool GetUdpUseMultiPortProbes() const {
            return SettingsStruct->UdpUseMultiPortProbes;
        }
        void SetUdpUseMultiPortProbes(bool& value) {
            SettingsStruct->UdpUseMultiPortProbes = value;
        }

        static const TSettings* Get() {
            // convenience method
            return SingletonWithPriority<TSettings, 100001>();
        }

    private:

        struct TSettingsStruct {
            bool CheckFullTypeOfService = false;
            bool FixReplyTypeOfService = false;
            size_t UdpSocketCount = 64;
            size_t PacketSize = 8000;
            size_t LinkPollerPacketSize = 4000;
            bool UdpUseMultiPortProbes = true;
            bool UseHwTimestamps = false;
        };

        TSettingsStruct* SettingsStruct; // destroyed automatically in AtExit()
    };
}
