IF UNAME_SYSNAME == "Darwin":
    cdef extern from "<mach/mach_time.h>":
        long mach_absolute_time()
        cdef struct mach_timebase_info:
            unsigned int numer
            unsigned int denom
        ctypedef mach_timebase_info mach_timebase_info_data_t

        int mach_timebase_info(mach_timebase_info_data_t *info)

    def monotonic():
        cdef mach_timebase_info_data_t info
        errorcode = mach_timebase_info(&info)
        if errorcode != 0:
            raise Exception("Failed to get timebase info, error code: %s" % (errorcode,))
        ticks_per_second = info.numer / info.denom * 1.0e9

        return mach_absolute_time() / ticks_per_second

ELIF UNAME_SYSNAME == "Linux":

    CLOCK_MONOTONIC = 1

    cdef extern from "<time.h>":
        ctypedef long clockid_t
        ctypedef long time_t

        cdef struct timespec:
            time_t tv_sec
            long tv_nsec

        int clock_gettime(clockid_t clk_id, timespec *tp)

    def monotonic():
        cdef timespec ts

        error_code = clock_gettime(CLOCK_MONOTONIC, &ts)
        if error_code != 0:
            raise Exception("Error when getting monotonic time, error code %s" % (error_code,))
        return float(ts.tv_sec) + ts.tv_nsec / 1.0e9
