#include "controller.h"

namespace NNetmon {
    namespace {
        using TSyncAddressesCall = TBaseSyncAddressesCall<TEchoService>;
    }

    IService* TEchoController::CreateService(TLog& logger, TContExecutor& executor) {
        Y_VERIFY(!Service);
        Service.Reset(MakeHolder<TEchoService>(logger, &executor));
        return &*Service;
    }

    void TEchoController::DestroyService() noexcept {
        Y_VERIFY(Service);
        Service.Destroy();
    }

    void TEchoController::SyncAddresses(PyObject* callback, const TVector<const TAddress*>& addressList) {
        Y_VERIFY(Service);
        return Execute(MakeIntrusive<TSyncAddressesCall>(callback, *Service, addressList));
    }
}
