#pragma once

#include "service.h"

#include <infra/netmon/agent/common/controller.h>

namespace NNetmon {
    class TEchoController : public TBaseController {
    public:
        TEchoController(PyObject* logger)
            : TBaseController("echo-service", logger)
        {
        }

        void SyncAddresses(PyObject* callback, const TVector<const TAddress*>& addressList);

    protected:
        IService* CreateService(TLog& logger, TContExecutor& executor) override;
        void DestroyService() noexcept override;

    private:
        THolder<TEchoService> Service;
    };
}
