#include "controller.h"

namespace NNetmon {
    namespace {
        using TSyncAddressesCall = TBaseSyncAddressesCall<TIcmpPollerService>;
        using TScheduleChecksCall = TBaseScheduleChecksCall<TIcmpPollerService>;
    }

    IService* TIcmpPollerController::CreateService(TLog& logger, TContExecutor& executor) {
        Y_VERIFY(!Service);
        Service.Reset(MakeHolder<TIcmpPollerService>(logger, &executor));
        return &*Service;
    }

    void TIcmpPollerController::DestroyService() noexcept {
        Y_VERIFY(Service);
        Service.Destroy();
    }

    void TIcmpPollerController::SyncAddresses(PyObject* callback, const TVector<const TAddress*>& addressList) {
        Y_VERIFY(Service);
        Execute(MakeIntrusive<TSyncAddressesCall>(callback, *Service, addressList));
    }

    void TIcmpPollerController::ScheduleChecks(PyObject* callback, const TVector<const TProbeConfig*>& configList) {
        Y_VERIFY(Service);
        Execute(MakeIntrusive<TScheduleChecksCall>(callback, *Service, configList));
    }
}
