#pragma once

#include "service.h"

#include <infra/netmon/agent/common/controller.h>

namespace NNetmon {
    class TIcmpPollerController : public TBaseController {
    public:
        TIcmpPollerController(PyObject* logger)
            : TBaseController("icmp-poller", logger)
        {
        }

        void SyncAddresses(PyObject* callback, const TVector<const TAddress*>& addressList);
        void ScheduleChecks(PyObject* callback, const TVector<const TProbeConfig*>& configList);

    protected:
        IService* CreateService(TLog& logger, TContExecutor& executor) override;
        void DestroyService() noexcept override;

    private:
        THolder<TIcmpPollerService> Service;
    };
}
