#pragma once

#include "headers.h"

#include <infra/netmon/agent/common/io.h>
#include <infra/netmon/agent/common/packet.h>
#include <infra/netmon/agent/common/utils.h>

namespace NNetmon {
    class TIcmpPacket : public TPacket, public TIntrusiveListItem<TIcmpPacket>, public TObjectFromPool<TIcmpPacket> {
    public:
        using TRef = THolder<TIcmpPacket>;
        using TListType = TIntrusiveListWithAutoDelete<TIcmpPacket, TDelete>;

        using TPacket::TPacket;

        template <typename... Args>
        static inline TRef Make(TPool& pool, Args&&... args) {
            return TRef(new (&pool) TIcmpPacket(std::forward<Args>(args)...));
        }

        virtual size_t GetDataOffset() const override {
            static_assert(sizeof(TIcmpHeaders::ICMP) == 8);
            return sizeof(TIcmpHeaders::ICMP) + 8;
        }

        inline void LoadStats() noexcept {
            Stats().SourceSentTime = UnalignedLoad64(Buf_.Data() + sizeof(TIcmpHeaders::ICMP));
        }

        inline void SaveStats() noexcept {
            UnalignedStore64(Buf_.Data() + sizeof(TIcmpHeaders::ICMP), Stats().SourceSentTime);
        }
    };

    class TIcmpIOHandler : public TNonCopyable {
    public:
        using TProbeIdType = ui8;
        using TPacket = TIcmpPacket;

        TIcmpIOHandler(TLog& logger, const NAddr::IRemoteAddrRef& addr);
        ~TIcmpIOHandler();

        const NAddr::IRemoteAddrRef& Addr() const noexcept;

        TMaybeIOStatus Read(TIcmpPacket& packet) noexcept;
        TMaybeIOStatus Write(TIcmpPacket& packet) noexcept;

        void PollD(TCont* cont, ui16 opFilter, const TInstant& deadline);
        void PollT(TCont* cont, ui16 opFilter, const TDuration& duration);

        static ui16 MaxProbeId() noexcept;

        void Close() noexcept;

    private:
        class TImpl;
        THolder<TImpl> Impl;
    };
}
