#pragma once

#include <util/system/platform.h>
#include <util/system/types.h>

// FIXME: it should be rather detected by simple compilation test
#ifdef _linux_
#define PKTSTYLE_GNU 1
#else
#define PKTSTYLE_BSD 1
#endif

#include <netinet/ip.h>
#ifdef _linux_
#include <linux/icmp.h> // ICMP_FILTER *and* struct icmphdr are defined there
#else
#include <netinet/ip_icmp.h>
#endif

#define DefineGetter(rettype, name, paramtype)    \
    static rettype name(const paramtype& pkt) {   \
        return name(const_cast<paramtype&>(pkt)); \
    }

class TIcmpHeaders {
public:
    // That's full IP packet without options.
    using IP =
#ifdef PKTSTYLE_GNU
        struct iphdr
#else
        struct ip
#endif
        ;

    // That's ICMP packet, it may be larger than simple ICMP ping/pong, so
    // don't rely on sizeof(ICMP)
    using ICMP =
#ifdef PKTSTYLE_GNU
        struct icmphdr
#else
        struct icmp
#endif
        ;

    // I don't craft IP packets, so this sort of wrappers to 4-bit values is ok
    static ui8 ip_hdrlen(const IP& pkt)
#ifdef PKTSTYLE_GNU
    {
        return pkt.ihl;
    }
#else
    {
        return pkt.ip_hl;
    }
#endif

    static ui8 ip_version(const IP& pkt)
#ifdef PKTSTYLE_GNU
    {
        return pkt.version;
    }
#else
    {
        return pkt.ip_v;
    }
#endif

    static ui16 ip_pktlen(const IP& pkt)
#ifdef PKTSTYLE_GNU
    {
        return pkt.tot_len;
    }
#else
    {
        return pkt.ip_len;
    }
#endif

    static ui8 ip_proto(const IP& pkt)
#ifdef PKTSTYLE_GNU
    {
        return pkt.protocol;
    }
#else
    {
        return pkt.ip_p;
    }
#endif

    // RFC 792, it can be done with offsetoff magic, but it's harder
    // type, code, checksum, id, sequence
    static const size_t IcmpPongHeaderLength = 1 + 1 + 2 + 2 + 2;

    DefineGetter(ui8, icmp_type, ICMP) static ui8& icmp_type(ICMP& pkt)
#ifdef PKTSTYLE_GNU
    {
        return pkt.type;
    }
#else
    {
        return pkt.icmp_type;
    }
#endif

    DefineGetter(ui8, icmp_code, ICMP) static ui8& icmp_code(ICMP& pkt)
#ifdef PKTSTYLE_GNU
    {
        return pkt.code;
    }
#else
    {
        return pkt.icmp_code;
    }
#endif

    DefineGetter(ui16, icmp_checksum, ICMP) static ui16& icmp_checksum(ICMP& pkt)
#ifdef PKTSTYLE_GNU
    {
        return pkt.checksum;
    }
#else
    {
        return pkt.icmp_cksum;
    }
#endif

    DefineGetter(ui16, echo_id, ICMP) static ui16& echo_id(ICMP& pkt)
#ifdef PKTSTYLE_GNU
    {
        return pkt.un.echo.id;
    }
#else
    {
        return pkt.icmp_hun.ih_idseq.icd_id;
    }
#endif

    DefineGetter(ui16, echo_seq, ICMP) static ui16& echo_seq(ICMP& pkt)
#ifdef PKTSTYLE_GNU
    {
        return pkt.un.echo.sequence;
    }
#else
    {
        return pkt.icmp_hun.ih_idseq.icd_seq;
    }
#endif
};

#undef DefineGetter
