#pragma once

#include <infra/netmon/agent/common/controller.h>
#include <infra/netmon/agent/common/probe.h>

namespace NNetmon {
    class TIcmpPollerService : public IService {
    public:
        TIcmpPollerService(TLog& logger, TContExecutor* executor);
        ~TIcmpPollerService();

        void Stop() noexcept override;

        void SyncAddresses(const TVector<TNetworkAddress>& addresses);
        void ScheduleChecks(TCont* cont, const TVector<TProbeConfig>& configs, TVector<TProbeReport>& reports);

    private:
        class TImpl;
        THolder<TImpl> Impl;
    };
}
