#include "controller.h"

namespace NNetmon {
    namespace {
        using TSyncAddressesCall = TLinkServiceAddressesCall<TLinkPollerService>;
        using TReportStatusCall = TLinkServiceReportStatusCall<TLinkPollerService>;
    }

    IService* TLinkPollerController::CreateService(TLog& logger, TContExecutor& executor) {
        Y_VERIFY(!Service);
        Service.Reset(MakeHolder<TLinkPollerService>(logger, &executor));
        return &*Service;
    }

    void TLinkPollerController::DestroyService() noexcept {
        Y_VERIFY(Service);
        Service.Destroy();
    }

    void TLinkPollerController::SyncAddresses(PyObject* callback,
                                              int srcPort, int dstPort,
                                              int bbIfIndex, const TString& bbSrcMac, const TString& bbDstMac,
                                              const TString& bbSrcIp, const TString& bbDstIp,
                                              int fbIfIndex, const TString& fbSrcMac, const TString& fbDstMac,
                                              const TString& fbSrcIp, const TString& fbDstIp) {
        Y_VERIFY(Service);
        Execute(MakeIntrusive<TSyncAddressesCall>(
            callback, *Service,
            static_cast<ui16>(srcPort), static_cast<ui16>(dstPort),
            bbIfIndex, bbSrcMac, bbDstMac, bbSrcIp, bbDstIp,
            fbIfIndex, fbSrcMac, fbDstMac, fbSrcIp, fbDstIp
        ));
    }

    void TLinkPollerController::ReportStatus(PyObject* callback) {
        Y_VERIFY(Service);
        Execute(MakeIntrusive<TReportStatusCall>(callback, *Service));
    }
}
