#pragma once

#include "service.h"

#include <infra/netmon/agent/common/controller.h>

namespace NNetmon {
    template <class T>
    class TLinkServiceAddressesCall : public TPythonCall {
    public:
        TLinkServiceAddressesCall(PyObject* callback, T& service, ui16 srcPort, ui16 dstPort,
                                  int bbIfIndex, const TString& bbSrcMac, const TString& bbDstMac,
                                  const TString& bbSrcIp, const TString& bbDstIp,
                                  int fbIfIndex, const TString& fbSrcMac, const TString& fbDstMac,
                                  const TString& fbSrcIp, const TString& fbDstIp)
            : TPythonCall(callback)
            , Service(service)
            , SrcPort(srcPort)
            , DstPort(dstPort)
            , BbIfIndex(bbIfIndex)
            , BbSrcMac(bbSrcMac)
            , BbDstMac(bbDstMac)
            , BbSrcIp(bbSrcIp)
            , BbDstIp(bbDstIp)
            , FbIfIndex(fbIfIndex)
            , FbSrcMac(fbSrcMac)
            , FbDstMac(fbDstMac)
            , FbSrcIp(fbSrcIp)
            , FbDstIp(fbDstIp)
        {}

    protected:
        void Dispatch(TCont*) override {
            Service.SyncAddresses(SrcPort, DstPort,
                                  BbIfIndex, BbSrcMac, BbDstMac, BbSrcIp, BbDstIp,
                                  FbIfIndex, FbSrcMac, FbDstMac, FbSrcIp, FbDstIp);
        }

    private:
        T& Service;
        TVector<TAddress> AddressList;
        ui16 SrcPort;
        ui16 DstPort;
        int BbIfIndex;
        TString BbSrcMac;
        TString BbDstMac;
        TString BbSrcIp;
        TString BbDstIp;
        int FbIfIndex;
        TString FbSrcMac;
        TString FbDstMac;
        TString FbSrcIp;
        TString FbDstIp;
    };

    template <class T>
    class TLinkServiceReportStatusCall : public TPythonCall {
    public:
        TLinkServiceReportStatusCall(PyObject* callback, T& service)
            : TPythonCall(callback)
            , Service(service)
        {}

    protected:
        void Dispatch(TCont*) override {
            Service.ReportStatus(ReportList);
        }

        PyObject* ToPython() override {
            return ConvertToPython(ReportList);
        }
    private:
        T& Service;
        TVector<TProbeReport> ReportList;
    };

    class TLinkPollerController : public TBaseController {
    public:
        TLinkPollerController(PyObject* logger)
            : TBaseController("link-poller", logger)
        {
        }

        void SyncAddresses(PyObject* callback,
                           int srcPort, int dstPort,
                           int bbIfIndex, const TString& bbSrcMac, const TString& bbDstMac,
                           const TString& bbSrcIp, const TString& bbDstIp,
                           int fbIfIndex, const TString& fbSrcMac, const TString& fbDstMac,
                           const TString& fbSrcIp, const TString& fbDstIp);
        void ReportStatus(PyObject* callback);

    protected:
        IService* CreateService(TLog& logger, TContExecutor& executor) override;
        void DestroyService() noexcept override;

    private:
        THolder<TLinkPollerService> Service;
    };

}
