#pragma once

#include <infra/netmon/agent/common/controller.h>
#include <infra/netmon/agent/common/probe.h>

namespace NNetmon {
    class TLinkPollerService : public IService {
    public:
        TLinkPollerService(TLog& logger, TContExecutor* executor);
        ~TLinkPollerService();

        void Stop() noexcept override;

        void SyncAddresses(ui16 srcPort, ui16 dstPort,
                           int bbIfIndex, const TString& bbSrcMac, const TString& bbDstMac,
                           const TString& bbSrcIp, const TString& bbDstIp,
                           int fbIfIndex, const TString& fbSrcMac, const TString& fbDstMac,
                           const TString& fbSrcIp, const TString& fbDstIp);

        void ReportStatus(TVector<TProbeReport>& reports);

    private:
        class TImpl;
        THolder<TImpl> Impl;
    };
}
