#include "controller.h"

namespace NNetmon {
    namespace {
        using TSyncAddressesCall = TBaseSyncAddressesCall<TTcpPollerService>;
        using TScheduleChecksCall = TBaseScheduleChecksCall<TTcpPollerService>;
    }

    IService* TTcpPollerController::CreateService(TLog& logger, TContExecutor& executor) {
        Y_VERIFY(!Service);
        Service.Reset(MakeHolder<TTcpPollerService>(logger, &executor));
        return &*Service;
    }

    void TTcpPollerController::DestroyService() noexcept {
        Y_VERIFY(Service);
        Service.Destroy();
    }

    void TTcpPollerController::SyncAddresses(PyObject* callback, const TVector<const TAddress*>& addressList) {
        Y_VERIFY(Service);
        Execute(MakeIntrusive<TSyncAddressesCall>(callback, *Service, addressList));
    }

    void TTcpPollerController::ScheduleChecks(PyObject* callback, const TVector<const TProbeConfig*>& configList) {
        Y_VERIFY(Service);
        Execute(MakeIntrusive<TScheduleChecksCall>(callback, *Service, configList));
    }
}
