#pragma once

#include <infra/netmon/agent/common/controller.h>
#include <infra/netmon/agent/common/probe.h>

namespace NNetmon {
    class TTcpPollerService : public IService {
    public:
        TTcpPollerService(TLog& logger, TContExecutor* executor);
        ~TTcpPollerService();

        void Stop() noexcept override;

        void SyncAddresses(const TVector<TNetworkAddress>& addresses);
        void ScheduleChecks(TCont* cont, const TVector<TProbeConfig>& configs, TVector<TProbeReport>& reports);

    private:
        class TImpl;
        THolder<TImpl> Impl;
    };
}
