#include "controller.h"

namespace NNetmon {
    namespace {
        using TSyncAddressesCall = TBaseSyncAddressesCall<TUdpPollerService>;
        using TScheduleChecksCall = TBaseScheduleChecksCall<TUdpPollerService>;
    }

    IService* TUdpPollerController::CreateService(TLog& logger, TContExecutor& executor) {
        Y_VERIFY(!Service);
        Service.Reset(MakeHolder<TUdpPollerService>(logger, &executor));
        return &*Service;
    }

    void TUdpPollerController::DestroyService() noexcept {
        Y_VERIFY(Service);
        Service.Destroy();
    }

    void TUdpPollerController::SyncAddresses(PyObject* callback, const TVector<const TAddress*>& addressList) {
        Y_VERIFY(Service);
        Execute(MakeIntrusive<TSyncAddressesCall>(callback, *Service, addressList));
    }

    void TUdpPollerController::ScheduleChecks(PyObject* callback, const TVector<const TProbeConfig*>& configList) {
        Y_VERIFY(Service);
        Execute(MakeIntrusive<TScheduleChecksCall>(callback, *Service, configList));
    }
}
