#pragma once

#include "service.h"

#include <infra/netmon/agent/common/controller.h>
#include <infra/netmon/agent/common/settings.h>

namespace NNetmon {
    class TUdpPollerController : public TBaseController {
    public:
        TUdpPollerController(PyObject* logger)
            : TBaseController("udp-poller", logger)
        {
            if (TSettings::Get()->GetUdpSocketCount() < 2) {
                ythrow yexception() << "socket count should be greater or equal to 2";
            }
        }

        void SyncAddresses(PyObject* callback, const TVector<const TAddress*>& addressList);
        void ScheduleChecks(PyObject* callback, const TVector<const TProbeConfig*>& configList);

    protected:
        IService* CreateService(TLog& logger, TContExecutor& executor) override;
        void DestroyService() noexcept override;

    private:
        THolder<TUdpPollerService> Service;
    };
}
