#include "controller.h"

namespace NNetmon {
    namespace {
        class TResolveCall : public TPythonCall {
        public:
            TResolveCall(PyObject* callback, TResolverService& service, const TString& name, int port, int family)
                : TPythonCall(callback)
                , Service(service)
                , Name(name)
                , Port(port)
                , Family(family)
            {
            }

        protected:
            void Dispatch(TCont*) override {
                Addrs = Service.Resolve(Name, Port, Family);
            }

            PyObject* ToPython() override {
                return ConvertToPython(Addrs);
            }

        private:
            TResolverService& Service;
            const TString Name;
            const int Port;
            const int Family;
            TMaybe<TAddrs> Addrs;
        };
    }

    IService* TResolverController::CreateService(TLog& logger, TContExecutor& executor) {
        Y_VERIFY(!Service);
        Service.Reset(MakeHolder<TResolverService>(logger, &executor));
        return &*Service;
    }

    void TResolverController::DestroyService() noexcept {
        Y_VERIFY(Service);
        Service.Destroy();
    }

    void TResolverController::Resolve(PyObject* callback, const TString& name, int port, int family) {
        Y_VERIFY(Service);
        Execute(MakeIntrusive<TResolveCall>(callback, *Service, name, port, family));
    }
}
