#pragma once

#include "service.h"

#include <infra/netmon/agent/common/utils.h>

namespace NNetmon {
    class TResolverController : public TBaseController {
    public:
        TResolverController(PyObject* logger)
            : TBaseController("resolver", logger)
        {
        }

        void Resolve(PyObject* callback, const TString& name, int port=0, int family=AF_UNSPEC);

    protected:
        IService* CreateService(TLog& logger, TContExecutor& executor) override;
        void DestroyService() noexcept override;

    private:
        THolder<TResolverService> Service;
    };
}
