#pragma once

#include <infra/netmon/agent/common/controller.h>

#include <util/network/address.h>

namespace NNetmon {
    using TAddrs = TVector<NAddr::IRemoteAddrRef>;

    class TResolverService : public IService {
    public:
        TResolverService(TLog& logger, TContExecutor* executor);
        ~TResolverService();

        void Stop() noexcept override;

        TMaybe<TAddrs> Resolve(const TString& name, int port, int family);

    private:
        class TImpl;
        THolder<TImpl> Impl;
    };
}
