# coding: utf-8
from __future__ import print_function

import requests
import json


def main():
    existing_expressions = requests.get("https://netmon.yandex-team.ru/api/expression/v1/list").json()
    for row in existing_expressions["expressions"]:
        if row["temporary"]:
            continue
        created_expressions = requests.post("https://netmon-prestable.n.yandex-team.ru/api/expression/v1/upsert", data=json.dumps({
            "expression": row["expression"],
            "id": row["id"],
            "owners": row["owners"]
        }))
        if created_expressions.status_code != 200:
            print(created_expressions.text)


if __name__ == '__main__':
    main()
