#include <infra/netmon/probe_aggregator_maintainer.h>
#include <infra/netmon/probe_dumper.h>
#include <infra/netmon/share_dead_hosts.h>
#include <infra/netmon/slice_collector.h>
#include <infra/netmon/switch_metrics.h>
#include <infra/netmon/user_data_storage.h>
#include <infra/netmon/provisioner.h>
#include <infra/netmon/metrics_updater.h>
#include <infra/netmon/tasks/enqueued_task_index.h>
#include <infra/netmon/tasks/finished_task_index.h>
#include <infra/netmon/api/aggregator_api.h>
#include <infra/netmon/api/client_api.h>
#include <infra/netmon/api/common_api.h>
#include <infra/netmon/api/expression_api.h>
#include <infra/netmon/api/history_api.h>
#include <infra/netmon/api/network_availability_api.h>
#include <infra/netmon/api/probes_api.h>
#include <infra/netmon/api/state_api.h>
#include <infra/netmon/api/tasks_api.h>
#include <infra/netmon/library/iam.h>
#include <infra/netmon/topology/clients/staff.h>

#include <util/stream/input.h>

using namespace NNetmon;

class TAggregationDaemon: private TNonCopyable {
public:
    TAggregationDaemon(TDaemonHelper& helper)
        : Helper(helper)
        , ExpressionStorage(!TLibrarySettings::Get()->GetZookeeperUri().empty())
        , TopologyStorage(TopologyUpdater, ExpressionStorage, GroupStorage)
        , CrossDcCounters(TopologyStorage)
        , SwitchSlaCounters(TopologyStorage)
        , SwitchSlaLPCounters(TopologyStorage)
        , InfraUpdater(TopologyStorage)
        , SolomonPusher(TSettings::Get()->GetSolomonPushUrl(), IamUpdater)
        , SlaMetricsUpdater(SolomonPusher, InfraUpdater)
        , CrossDcMetricsUpdater(CrossDcCounters, TopologyStorage, SolomonPusher, InfraUpdater)

        , InterSwitchMetricsUpdater(SwitchSlaCounters)
        , InterSwitchRttMetricsUpdater(SwitchSlaCounters)
        , LinkPollerMetricsUpdater(SwitchSlaLPCounters)
        , InterSwitchLPMetricsUpdater(SwitchSlaLPCounters)
        , InterSwitchRttLPMetricsUpdater(SwitchSlaLPCounters)

        , LinkPollerHostsUpdater(TopologyStorage)
        , SeenHostsUpdater(TopologyStorage)
        , SeenHostsMaintainer(TopologyStorage, SeenHostsUpdater)
        , WalleUpdater(TopologyStorage, CalculateWalleUpdaterTimeOffset())
        , RtUpdater(TopologyStorage)
        , SliceCollector(TopologyStorage)
        , ProbeAggregatorMaintainer(SliceCollector)
        , SlicerDumper(Queue)
        , HistoryRequester(TopologyStorage)

        , ProbeScheduleMaintainer(TopologyStorage, WalleUpdater, RtUpdater)

        // agent tasks
        , EnqueuedTaskStorage("/enqueued_tasks", EnqueuedTaskIndex)
        , FinishedTaskStorage("/finished_tasks", FinishedTaskIndex)

        , WalleUpdaterSubscription(WalleUpdater.OnUpdated().Subscribe([this](){
              ShareDeadHosts(WalleUpdater);
          }))

        // aggregator handles
        , AggregatorContext(
                ExpressionStorage, UserDataStorage, TopologyStorage, SliceCollector, SlicerDumper,
                ProbeAggregatorMaintainer, SeenHostsUpdater, SeenHostsMaintainer, TerminatedHostsUpdater,
                WalleUpdater, InfraUpdater, FinishedTaskIndex, HistoryRequester, ProbeScheduleMaintainer,
                InterSwitchMetricsUpdater, InterSwitchRttMetricsUpdater, LinkPollerMetricsUpdater,
                InterSwitchLPMetricsUpdater, InterSwitchRttLPMetricsUpdater)
        , PingHandler(AggregatorContext)
        , TagsHandler(AggregatorContext)
        , SeenHostsHandler(AggregatorContext)
        , TerminatedHostsHandler(AggregatorContext)
        , InterestedHostsHandler(AggregatorContext)
        , HistoryLimitsHandler(AggregatorContext)
        , QueueMappingHandler(AggregatorContext)

        , ReplaceDeadHostsHandler(AggregatorContext)

        , DcLatestStateHandler(AggregatorContext)
        , DcStateHistoryHandler(AggregatorContext)
        , DcProbesHandler(AggregatorContext)
        , DcHistoryHandler(AggregatorContext)
        , DcAliveHandler(AggregatorContext)

        , QueueLatestStateHandler(AggregatorContext)
        , QueueStateHistoryHandler(AggregatorContext)
        , QueueProbesHandler(AggregatorContext)
        , QueueHistoryHandler(AggregatorContext)
        , QueueAliveHandler(AggregatorContext)

        , SwitchLatestStateHandler(AggregatorContext)
        , SwitchStateHistoryHandler(AggregatorContext)
        , SwitchProbesHandler(AggregatorContext)
        , SwitchHistoryHandler(AggregatorContext)
        , SwitchAliveHandler(AggregatorContext)

        , ProbesHistoryHandler(AggregatorContext)
        , QualityStatsHandler(AggregatorContext)
        , HostsHandler(AggregatorContext)
        , FindByVersionHandler(AggregatorContext)
        , AgentReportHandler(AggregatorContext)
        , CoverageHandler(AggregatorContext)
        , SwitchMetricsHandler(AggregatorContext)
        , InterSwitchMetricsVerboseHandler(AggregatorContext)
        , LinkPollerMetricsVerboseHandler(AggregatorContext)

        // common handles
        , CommonContext(TopologyStorage)
        , MetricsStatsHandler(CommonContext)
        , AllocStatsHandler(CommonContext)

        // client api
        , ClientApiContext(
                Queue, SlicerDumper,
                GroupStorage, TopologyUpdater, TopologyStorage, ProbeScheduleMaintainer,
                LinkPollerHostsUpdater, TerminatedHostsUpdater, WalleUpdater,
                CrossDcCounters, SwitchSlaCounters, SwitchSlaLPCounters,
                EnqueuedTaskStorage, EnqueuedTaskIndex, FinishedTaskStorage, FinishedTaskIndex)
        , SendReportsHandler(ClientApiContext)
        , ExpandGroupHandler(ClientApiContext)
        , EnqueuedTasksHandler(ClientApiContext)
        , FinishTasksHandler(ClientApiContext)
        , ProvisioningHandler(ClientApiContext)
        , ScheduledProbesHandler(ClientApiContext)
        , TerminatedHostHandler(ClientApiContext)

        // tasks api
        , TasksContext(
                TopologyStorage, SeenHostsUpdater, StaffStorage,
                EnqueuedTaskStorage, EnqueuedTaskIndex, FinishedTaskIndex)
        , EnqueueTaskHandler(TasksContext)
        , FetchTaskHandler(TasksContext)

        // expression api
        , ExpressionContext(
                TopologyStorage, ExpressionStorage, SliceCollector,
                ProbeAggregatorMaintainer, GroupStorage, StaffStorage, UserDataStorage)
        , ExpressionHostsHandler(ExpressionContext)
        , ExpressionExpandHandler(ExpressionContext)
        , ExpressionListHandler(ExpressionContext)
        , ExpressionGetHandler(ExpressionContext)
        , ExpressionUpsertHandler(ExpressionContext)
        , ExpressionDeleteHandler(ExpressionContext)
        , ExpressionLimitsHandler(ExpressionContext)
        , ExpressionLimitsUpsertHandler(ExpressionContext)
        , ExpressionLimitsDeleteHandler(ExpressionContext)
        , ExpressionMetadataHandler(ExpressionContext)
        , ExpressionMetadataUpsertHandler(ExpressionContext)
        , ExpressionMetadataDeleteHandler(ExpressionContext)
    {
        // aggregator handles
        Helper.RegisterHttpService("/api/v1/ping", PingHandler);
        Helper.RegisterHttpService("/api/v1/tags", TagsHandler);
        Helper.RegisterHttpService("/api/v1/seen_hosts", SeenHostsHandler);
        Helper.RegisterHttpService("/api/v1/terminated_hosts", TerminatedHostsHandler);
        Helper.RegisterHttpService("/api/v1/interested_hosts", InterestedHostsHandler);
        Helper.RegisterHttpService("/api/v1/history_limits", HistoryLimitsHandler);
        Helper.RegisterHttpService("/api/v1/queue_mapping", QueueMappingHandler);

        Helper.RegisterHttpService("/api/v1/replace_dead_hosts", ReplaceDeadHostsHandler);

        Helper.RegisterHttpService("/api/v1/dc/latest", DcLatestStateHandler);
        Helper.RegisterHttpService("/api/v1/dc/state/latest", DcLatestStateHandler);
        Helper.RegisterHttpService("/api/v1/dc/state/history", DcStateHistoryHandler);
        Helper.RegisterHttpService("/api/v1/dc/probes", DcProbesHandler);
        Helper.RegisterHttpService("/api/v1/dc/history", DcHistoryHandler);
        Helper.RegisterHttpService("/api/v1/dc/alive", DcAliveHandler);

        Helper.RegisterHttpService("/api/v1/queue/latest", QueueLatestStateHandler);
        Helper.RegisterHttpService("/api/v1/queue/state/latest", QueueLatestStateHandler);
        Helper.RegisterHttpService("/api/v1/queue/state/history", QueueStateHistoryHandler);
        Helper.RegisterHttpService("/api/v1/queue/probes", QueueProbesHandler);
        Helper.RegisterHttpService("/api/v1/queue/history", QueueHistoryHandler);
        Helper.RegisterHttpService("/api/v1/queue/alive", QueueAliveHandler);

        Helper.RegisterHttpService("/api/v1/switch/latest", SwitchLatestStateHandler);
        Helper.RegisterHttpService("/api/v1/switch/state/latest", SwitchLatestStateHandler);
        Helper.RegisterHttpService("/api/v1/switch/state/history", SwitchStateHistoryHandler);
        Helper.RegisterHttpService("/api/v1/switch/probes", SwitchProbesHandler);
        Helper.RegisterHttpService("/api/v1/switch/history", SwitchHistoryHandler);
        Helper.RegisterHttpService("/api/v1/switch/alive", SwitchAliveHandler);

        Helper.RegisterHttpService("/api/v1/probes/history", ProbesHistoryHandler);

        Helper.RegisterHttpService("/api/v1/quality", QualityStatsHandler);
        Helper.RegisterHttpService("/api/v1/hosts", HostsHandler);
        Helper.RegisterHttpService("/api/v1/find_by_version", FindByVersionHandler);
        Helper.RegisterHttpService("/api/v1/agent_report", AgentReportHandler);
        Helper.RegisterHttpService("/api/v1/coverage", CoverageHandler);
        Helper.RegisterHttpService("/api/v1/switch_metrics", SwitchMetricsHandler);
        Helper.RegisterHttpService("/api/v1/inter_switch_metrics_verbose", InterSwitchMetricsVerboseHandler);
        Helper.RegisterHttpService("/api/v1/link_poller_metrics_verbose", LinkPollerMetricsVerboseHandler);

        // common handles
        Helper.RegisterHttpService("/api/v1/metrics", MetricsStatsHandler);
        Helper.RegisterHttpService("/api/v1/allocator", AllocStatsHandler);

        // client api
        Helper.RegisterHttpService("/api/client/v1/send_reports", SendReportsHandler);
        Helper.RegisterHttpService("/api/client/v1/expand_groups", ExpandGroupHandler);
        Helper.RegisterHttpService("/api/client/v1/enqueued_tasks", EnqueuedTasksHandler);
        Helper.RegisterHttpService("/api/client/v1/finish_tasks", FinishTasksHandler);
        Helper.RegisterHttpService("/api/client/v1/provisioning_info", ProvisioningHandler);
        Helper.RegisterHttpService("/api/client/v1/scheduled_probes", ScheduledProbesHandler);
        Helper.RegisterHttpService("/api/client/v1/terminated_host", TerminatedHostHandler);

        // tasks api
        Helper.RegisterHttpService("/api/tasks/v1/enqueue", EnqueueTaskHandler);
        Helper.RegisterHttpService("/api/tasks/v1/fetch", FetchTaskHandler);

        // expression api
        Helper.RegisterHttpService("/api/expression/v1/hosts", ExpressionHostsHandler);
        Helper.RegisterHttpService("/api/expression/v1/expand", ExpressionExpandHandler);
        Helper.RegisterHttpService("/api/expression/v1/list", ExpressionListHandler);
        Helper.RegisterHttpService("/api/expression/v1/get", ExpressionGetHandler);
        Helper.RegisterHttpService("/api/expression/v1/upsert", ExpressionUpsertHandler);
        Helper.RegisterHttpService("/api/expression/v1/delete", ExpressionDeleteHandler);

        Helper.RegisterHttpService("/api/expression/v1/limits", ExpressionLimitsHandler);
        Helper.RegisterHttpService("/api/expression/v1/limits_upsert", ExpressionLimitsUpsertHandler);
        Helper.RegisterHttpService("/api/expression/v1/limits_delete", ExpressionLimitsDeleteHandler);
        Helper.RegisterHttpService("/api/expression/v1/metadata", ExpressionMetadataHandler);
        Helper.RegisterHttpService("/api/expression/v1/metadata_upsert", ExpressionMetadataUpsertHandler);
        Helper.RegisterHttpService("/api/expression/v1/metadata_delete", ExpressionMetadataDeleteHandler);
    }

    void Run() {
        TSlicerDumper::TThreadGuard dumperGuard(SlicerDumper);

        Helper.Run();
    }

private:
    TDaemonHelper& Helper;

    TGroupStorage GroupStorage;
    TExpressionStorage ExpressionStorage;
    TTopologyUpdater TopologyUpdater;
    TTopologyStorage TopologyStorage;

    TCrossDcCounters CrossDcCounters;
    TSwitchSlaCounters SwitchSlaCounters;
    TSwitchSlaCounters SwitchSlaLPCounters;

    TIamUpdater IamUpdater;
    TInfraUpdater InfraUpdater;

    TSolomonPusher SolomonPusher;

    TCommonMetricsUpdater CommonMetricsUpdater;
    TSlaMetricsUpdater SlaMetricsUpdater;
    TCrossDcMetricsUpdater CrossDcMetricsUpdater;

    TInterSwitchMetricsUpdater InterSwitchMetricsUpdater;
    TInterSwitchRttMetricsUpdater InterSwitchRttMetricsUpdater;
    TLinkPollerMetricsUpdater LinkPollerMetricsUpdater;
    TInterSwitchMetricsUpdater InterSwitchLPMetricsUpdater;
    TInterSwitchRttMetricsUpdater InterSwitchRttLPMetricsUpdater;

    TDumperProbeBatch::TRecordQueue Queue;

    TLinkPollerHostsUpdater LinkPollerHostsUpdater;
    TSeenHostsUpdater SeenHostsUpdater;
    TSeenHostsMaintainer SeenHostsMaintainer;
    TTerminatedHostsUpdater TerminatedHostsUpdater;
    TWalleUpdater WalleUpdater;
    TRtUpdater RtUpdater;
    TStaffStorage StaffStorage;

    TSliceCollector SliceCollector;
    TProbeAggregatorMaintainer ProbeAggregatorMaintainer;
    TSlicerDumper SlicerDumper;
    THistoryRequester HistoryRequester;

    TProbeScheduleMaintainer ProbeScheduleMaintainer;

    TEnqueuedTaskIndex EnqueuedTaskIndex;
    TAgentTaskStorage EnqueuedTaskStorage;
    TFinishedTaskIndex FinishedTaskIndex;
    TAgentTaskStorage FinishedTaskStorage;

    TUserDataStorage UserDataStorage;

    TVoidEventHub::TSubscriptionGuard WalleUpdaterSubscription;

    TAggregatorContext AggregatorContext;

    TPingHandler PingHandler;
    TTagsHandler TagsHandler;
    TSeenHostsHandler SeenHostsHandler;
    TTerminatedHostsHandler TerminatedHostsHandler;
    TInterestedHostsHandler InterestedHostsHandler;
    THistoryLimitsHandler HistoryLimitsHandler;
    TQueueMappingHandler QueueMappingHandler;

    TReplaceDeadHostsHandler ReplaceDeadHostsHandler;

    TDcLatestStateHandler DcLatestStateHandler;
    TDcStateHistoryHandler DcStateHistoryHandler;
    TDcProbesHandler DcProbesHandler;
    TDcHistoryHandler DcHistoryHandler;
    TDcAliveHandler DcAliveHandler;

    TLineLatestStateHandler QueueLatestStateHandler;
    TLineStateHistoryHandler QueueStateHistoryHandler;
    TLineProbesHandler QueueProbesHandler;
    TLineHistoryHandler QueueHistoryHandler;
    TLineAliveHandler QueueAliveHandler;

    TSwitchLatestStateHandler SwitchLatestStateHandler;
    TSwitchStateHistoryHandler SwitchStateHistoryHandler;
    TSwitchProbesHandler SwitchProbesHandler;
    TSwitchHistoryHandler SwitchHistoryHandler;
    TSwitchAliveHandler SwitchAliveHandler;

    TProbesHistoryHandler ProbesHistoryHandler;

    TQualityStatsHandler QualityStatsHandler;
    THostsHandler HostsHandler;
    TFindByVersionHandler FindByVersionHandler;
    TAgentReportHandler AgentReportHandler;
    TCoverageHandler CoverageHandler;
    TSwitchMetricsHandler SwitchMetricsHandler;
    TInterSwitchMetricsVerboseHandler InterSwitchMetricsVerboseHandler;
    TLinkPollerMetricsVerboseHandler LinkPollerMetricsVerboseHandler;

    TCommonContext CommonContext;
    TMetricsStatsHandler MetricsStatsHandler;
    TAllocStatsHandler AllocStatsHandler;

    TClientApiContext ClientApiContext;
    TSendReportsHandler SendReportsHandler;
    TExpandGroupHandler ExpandGroupHandler;
    TEnqueuedTasksHandler EnqueuedTasksHandler;
    TFinishTasksHandler FinishTasksHandler;
    TProvisioningHandler ProvisioningHandler;
    TScheduledProbesHandler ScheduledProbesHandler;
    TTerminatedHostHandler TerminatedHostHandler;

    TTasksContext TasksContext;
    TEnqueueTaskHandler EnqueueTaskHandler;
    TFetchTaskHandler FetchTaskHandler;

    TExpressionContext ExpressionContext;
    TExpressionHostsHandler ExpressionHostsHandler;
    TExpressionExpandHandler ExpressionExpandHandler;
    TExpressionListHandler ExpressionListHandler;
    TExpressionGetHandler ExpressionGetHandler;
    TExpressionUpsertHandler ExpressionUpsertHandler;
    TExpressionDeleteHandler ExpressionDeleteHandler;
    TExpressionLimitsHandler ExpressionLimitsHandler;
    TExpressionLimitsUpsertHandler ExpressionLimitsUpsertHandler;
    TExpressionLimitsDeleteHandler ExpressionLimitsDeleteHandler;
    TExpressionMetadataHandler ExpressionMetadataHandler;
    TExpressionMetadataUpsertHandler ExpressionMetadataUpsertHandler;
    TExpressionMetadataDeleteHandler ExpressionMetadataDeleteHandler;
};

int main(int argc, const char** argv) {
    return TDaemonHelper::RunFromMain<TNetmonProvisioner, TAggregationDaemon>(argc, argv);
}
