#pragma once

#include <infra/netmon/library/api_handler_helpers.h>
#include <infra/netmon/topology/topology_storage.h>

#include <library/cpp/json/writer/json.h>

namespace NNetmon {
    class TCommonContext {
    public:
        TCommonContext(const TTopologyStorage& topologyStorage)
            : TopologyStorage(topologyStorage)
        {
        }

        inline const TTopologyStorage& GetTopologyStorage() const {
            return TopologyStorage;
        }

    private:
        const TTopologyStorage& TopologyStorage;
    };

    class TImmediateCommonReply: public THttpReply<THttpDispatcher, TCommonContext> {
    public:
        TImmediateCommonReply(TCommonContext& serverContext, const TServiceRequest::TRef clientContext)
            : THttpReply<THttpDispatcher, TCommonContext>(serverContext, clientContext)
        {
        }

        virtual void Process() = 0;

        void PreprocessRequest(const THttpInput&) {
        }
        void ParseRequest(THttpInput&) {
        }
        void WriteResponse(THttpOutput& output) {
            output << THttpResponse()
                .SetContentType(TStringBuf("application/json"))
                .SetContent(Response.Str());
            output.Finish();
        }
        inline NJsonWriter::TBuf& GetResponse() {
            return Response;
        }

    private:
        NJsonWriter::TBuf Response;
    };

    class TMetricsStatsReply: public TImmediateCommonReply {
    public:
        using TImmediateCommonReply::TImmediateCommonReply;

        void Process() override;
    };

    class TAllocStatsReply: public TImmediateCommonReply {
    public:
        using TImmediateCommonReply::TImmediateCommonReply;

        void Process() override;
    };

    class TDummyQualityStatsReply: public TImmediateCommonReply {
    public:
        using TImmediateCommonReply::TImmediateCommonReply;

        void Process() override;
    };

    using TMetricsStatsHandler = THttpHandler<TMetricsStatsReply>;
    using TAllocStatsHandler = THttpHandler<TAllocStatsReply>;
    using TDummyQualityStatsHandler = THttpHandler<TDummyQualityStatsReply>;
};
