#pragma once

#include <infra/netmon/api/aggregator_api.h>
#include <infra/netmon/library/clickhouse/client.h>

namespace NNetmon {
    class TClickhouseAggregatorReply: public TBaseAggregatorReply<THttpFutureDispatcher> {
    public:
        using TBaseAggregatorReply::TBaseAggregatorReply;

        NThreading::TFuture<void> Process();

        virtual TString GetQuery() = 0;

        virtual void OnStart() = 0;
        virtual void OnBlock(const NClickHouse::TBlock& block) = 0;
        virtual void OnEnd() = 0;
    };

    class TProbesHistoryReply: public TClickhouseAggregatorReply {
    public:
        using TClickhouseAggregatorReply::TClickhouseAggregatorReply;

        TString GetQuery() override;

        void OnStart() override;
        void OnBlock(const NClickHouse::TBlock& block) override;
        void OnEnd() override;

    private:
        TExpressionId ExpressionId;
        TTopologyStorage::THostSetBox::TConstValueRef SeenHosts;
        TTopologyStorage::THostSetBox::TConstValueRef DeadHosts;
        ui64 Selected = 0;
    };

    class TDcProbesReply: public TFutureAggregatorReply {
    public:
        using TFutureAggregatorReply::TFutureAggregatorReply;

        TThreadPool::TFuture Process() override;
    };

    class TLineProbesReply: public TFutureAggregatorReply {
    public:
        using TFutureAggregatorReply::TFutureAggregatorReply;

        TThreadPool::TFuture Process() override;
    };

    class TSwitchProbesReply: public TFutureAggregatorReply {
    public:
        using TFutureAggregatorReply::TFutureAggregatorReply;

        TThreadPool::TFuture Process() override;
    };

    using TProbesHistoryHandler = THttpHandler<TProbesHistoryReply>;

    using TDcProbesHandler = THttpHandler<TDcProbesReply>;
    using TLineProbesHandler = THttpHandler<TLineProbesReply>;
    using TSwitchProbesHandler = THttpHandler<TSwitchProbesReply>;
}
