#pragma once

#include <infra/netmon/library/api_handler_helpers.h>
#include <infra/netmon/probe_dumper.h>
#include <infra/netmon/probe_slice_merger.h>
#include <infra/netmon/probe_slice_dumper.h>
#include <infra/netmon/probe_slice_history.h>
#include <infra/netmon/terminated_hosts.h>
#include <infra/netmon/monitors.h>

#include <infra/netmon/idl/api.fbs.h>

namespace NNetmon {
    class TSlicerContext : public TNonCopyable {
    public:
        TSlicerContext(const TExpressionStorage& expressionStorage,
                       const TProbeSliceMaintainer& sliceMaintainer,
                       const TProbeSliceMerger& sliceMerger,
                       const TProbeSliceDumper& sliceDumper,
                       const TProbeSliceHistory& sliceHistory,
                       const TTopologyStorage& topologyStorage,
                       const TSeenHostsUpdater& seenHostsUpdater,
                       TTerminatedHostsMaintainer& terminatedHostsMaintainer,
                       const TWalleUpdater& walleUpdater,
                       const TClickhouseDumper& probeDumper,
                       const TClickhouseMonitor& clickhouseMonitor,
                       TDumperProbeBatch::TRecordQueue& probeQueue)
            : ExpressionStorage(expressionStorage)
            , SliceMaintainer(sliceMaintainer)
            , SliceMerger(sliceMerger)
            , SliceDumper(sliceDumper)
            , SliceHistory(sliceHistory)
            , TopologyStorage(topologyStorage)
            , SeenHostsUpdater(seenHostsUpdater)
            , TerminatedHostsMaintainer(terminatedHostsMaintainer)
            , WalleUpdater(walleUpdater)
            , ProbeDumper(probeDumper)
            , ClickhouseMonitor(clickhouseMonitor)
            , ProbeQueue(probeQueue)
        {
        }

        inline const TExpressionStorage& GetExpressionStorage() const {
            return ExpressionStorage;
        }
        inline const TProbeSliceMaintainer& GetSliceMaintainer() const {
            return SliceMaintainer;
        }
        inline const TProbeSliceMerger& GetSliceMerger() const {
            return SliceMerger;
        }
        inline const TProbeSliceDumper& GetSliceDumper() const {
            return SliceDumper;
        }
        inline const TProbeSliceHistory& GetSliceHistory() const {
            return SliceHistory;
        }
        inline const TTopologyStorage& GetTopologyStorage() const {
            return TopologyStorage;
        }
        inline const TSeenHostsUpdater& GetSeenHostsUpdater() const {
            return SeenHostsUpdater;
        }
        inline TTerminatedHostsMaintainer& GetTerminatedHostsMaintainer() const {
            return TerminatedHostsMaintainer;
        }
        inline const TWalleUpdater& GetWalleUpdater() const {
            return WalleUpdater;
        }
        inline const TClickhouseDumper& GetProbeDumper() const {
            return ProbeDumper;
        }
        inline const TClickhouseMonitor& GetClickhouseMonitor() const {
            return ClickhouseMonitor;
        }
        inline TDumperProbeBatch::TRecordQueue& GetProbeQueue() {
            return ProbeQueue;
        }

    private:
        const TExpressionStorage& ExpressionStorage;
        const TProbeSliceMaintainer& SliceMaintainer;
        const TProbeSliceMerger& SliceMerger;
        const TProbeSliceDumper& SliceDumper;
        const TProbeSliceHistory& SliceHistory;
        const TTopologyStorage& TopologyStorage;
        const TSeenHostsUpdater& SeenHostsUpdater;
        TTerminatedHostsMaintainer& TerminatedHostsMaintainer;
        const TWalleUpdater& WalleUpdater;
        const TClickhouseDumper& ProbeDumper;
        const TClickhouseMonitor& ClickhouseMonitor;
        TDumperProbeBatch::TRecordQueue& ProbeQueue;
    };

    template <class TRequest>
    using TSlicerReply = TInterconnectReply<TInterconnectDispatcher, TSlicerContext, TRequest>;

    class TDatacenterStateReply: public TSlicerReply<NApi::TStateRequest> {
    public:
        using TSlicerReply<NApi::TStateRequest>::TSlicerReply;

        void Process();
    };

    class TLineStateReply: public TSlicerReply<NApi::TStateRequest> {
    public:
        using TSlicerReply<NApi::TStateRequest>::TSlicerReply;

        void Process();
    };

    class TSwitchStateReply: public TSlicerReply<NApi::TStateRequest> {
    public:
        using TSlicerReply<NApi::TStateRequest>::TSlicerReply;

        void Process();
    };

    class TDatacenterHistoryStateReply: public TSlicerReply<NApi::TDatacenterHistoryStateRequest> {
    public:
        using TSlicerReply<NApi::TDatacenterHistoryStateRequest>::TSlicerReply;

        void Process();
    };

    class TLineHistoryStateReply: public TSlicerReply<NApi::TLineHistoryStateRequest> {
    public:
        using TSlicerReply<NApi::TLineHistoryStateRequest>::TSlicerReply;

        void Process();
    };

    class TSwitchHistoryStateReply: public TSlicerReply<NApi::TSwitchHistoryStateRequest> {
    public:
        using TSlicerReply<NApi::TSwitchHistoryStateRequest>::TSlicerReply;

        void Process();
    };

    class TDatacenterHistorySeriesReply: public TSlicerReply<NApi::TDatacenterHistorySeriesRequest> {
    public:
        using TSlicerReply<NApi::TDatacenterHistorySeriesRequest>::TSlicerReply;

        void Process();
    };

    class TLineHistorySeriesReply: public TSlicerReply<NApi::TLineHistorySeriesRequest> {
    public:
        using TSlicerReply<NApi::TLineHistorySeriesRequest>::TSlicerReply;

        void Process();
    };

    class TSwitchHistorySeriesReply: public TSlicerReply<NApi::TSwitchHistorySeriesRequest> {
    public:
        using TSlicerReply<NApi::TSwitchHistorySeriesRequest>::TSlicerReply;

        void Process();
    };

    class TAggregatorKeysReply: public TSlicerReply<NApi::TAggregatorKeysRequest> {
    public:
        using TSlicerReply<NApi::TAggregatorKeysRequest>::TSlicerReply;

        void Process();
    };

    class TProbesReply: public TSlicerReply<NApi::TProbesRequest> {
    public:
        using TSlicerReply<NApi::TProbesRequest>::TSlicerReply;

        void Process();
    };

    class TSlicerSeenHostsReply: public TSlicerReply<NApi::TSeenHostsRequest> {
    public:
        using TSlicerReply<NApi::TSeenHostsRequest>::TSlicerReply;

        void Process();
    };

    class TSlicerTerminatedHostsReply: public TSlicerReply<NApi::TTerminatedHostsRequest> {
    public:
        using TSlicerReply<NApi::TTerminatedHostsRequest>::TSlicerReply;

        void Process();
    };

    class TUpdateTerminatedHostsReply: public TSlicerReply<NApi::TUpdateTerminatedHostsRequest> {
    public:
        using TSlicerReply<NApi::TUpdateTerminatedHostsRequest>::TSlicerReply;

        void Process();
    };

    class TAppendProbesReply: public TSlicerReply<NApi::TAppendProbesRequest> {
    public:
        using TSlicerReply<NApi::TAppendProbesRequest>::TSlicerReply;

        void Process();
    };

    class TSlicerPingReply: public THttpReply<THttpDispatcher, TSlicerContext> {
    public:
        TSlicerPingReply(TSlicerContext& serverContext, const TServiceRequest::TRef clientContext)
            : THttpReply<THttpDispatcher, TSlicerContext>(serverContext, clientContext)
        {
        }

        void Process();

        void PreprocessRequest(THttpInput&) {
        }
        void ParseRequest(THttpInput&) {
        }
        void WriteResponse(THttpOutput& output) {
            output << THttpResponse()
                .SetContentType(TStringBuf("application/json"))
                .SetContent(Response.Str());
            output.Finish();
        }
        inline NJsonWriter::TBuf& GetResponse() {
            return Response;
        }

    private:
        NJsonWriter::TBuf Response;
    };

    template <class TReply>
    using TSlicerHandler = TInterconnectHandler<TReply>;

    using TDatacenterStateHandler = TSlicerHandler<TDatacenterStateReply>;
    using TLineStateHandler = TSlicerHandler<TLineStateReply>;
    using TSwitchStateHandler = TSlicerHandler<TSwitchStateReply>;

    using TDatacenterHistoryStateHandler = TSlicerHandler<TDatacenterHistoryStateReply>;
    using TLineHistoryStateHandler = TSlicerHandler<TLineHistoryStateReply>;
    using TSwitchHistoryStateHandler = TSlicerHandler<TSwitchHistoryStateReply>;

    using TDatacenterHistorySeriesHandler = TSlicerHandler<TDatacenterHistorySeriesReply>;
    using TLineHistorySeriesHandler = TSlicerHandler<TLineHistorySeriesReply>;
    using TSwitchHistorySeriesHandler = TSlicerHandler<TSwitchHistorySeriesReply>;

    using TAggregatorKeysHandler = TSlicerHandler<TAggregatorKeysReply>;
    using TProbesHandler = TSlicerHandler<TProbesReply>;
    using TSlicerSeenHostsHandler = TSlicerHandler<TSlicerSeenHostsReply>;
    using TSlicerTerminatedHostsHandler = TSlicerHandler<TSlicerTerminatedHostsReply>;
    using TUpdateTerminatedHostsHandler = TSlicerHandler<TUpdateTerminatedHostsReply>;
    using TAppendProbesHandler = TSlicerHandler<TAppendProbesReply>;

    using TSlicerPingHandler = THttpHandler<TSlicerPingReply>;
}
