#pragma once

#include <infra/netmon/api/aggregator_api.h>

namespace NNetmon {
    class TDcLatestStateReply: public TImmediateAggregatorReply {
    public:
        using TImmediateAggregatorReply::TImmediateAggregatorReply;

        void Process() override;
    };

    class TDcStateHistoryReply: public TFutureAggregatorReply {
    public:
        using TFutureAggregatorReply::TFutureAggregatorReply;

        TThreadPool::TFuture Process() override;
    };

    class TLineLatestStateReply: public TImmediateAggregatorReply {
    public:
        using TImmediateAggregatorReply::TImmediateAggregatorReply;

        void Process() override;
    };

    class TLineStateHistoryReply: public TFutureAggregatorReply {
    public:
        using TFutureAggregatorReply::TFutureAggregatorReply;

        TThreadPool::TFuture Process() override;
    };

    class TSwitchLatestStateReply: public TImmediateAggregatorReply {
    public:
        using TImmediateAggregatorReply::TImmediateAggregatorReply;

        void Process() override;
    };

    class TSwitchStateHistoryReply: public TFutureAggregatorReply {
    public:
        using TFutureAggregatorReply::TFutureAggregatorReply;

        TThreadPool::TFuture Process() override;
    };

    using TDcLatestStateHandler = THttpHandler<TDcLatestStateReply>;
    using TDcStateHistoryHandler = THttpHandler<TDcStateHistoryReply>;

    using TLineLatestStateHandler = THttpHandler<TLineLatestStateReply>;
    using TLineStateHistoryHandler = THttpHandler<TLineStateHistoryReply>;

    using TSwitchLatestStateHandler = THttpHandler<TSwitchLatestStateReply>;
    using TSwitchStateHistoryHandler = THttpHandler<TSwitchStateHistoryReply>;
}
