#pragma once

#include <infra/netmon/seen_hosts.h>
#include <infra/netmon/topology/topology_storage.h>
#include <infra/netmon/tasks/enqueued_task_index.h>
#include <infra/netmon/tasks/finished_task_index.h>
#include <infra/netmon/library/api_handler_helpers.h>
#include <infra/netmon/topology/clients/staff.h>

namespace NNetmon {
    class TTasksContext : public TNonCopyable {
    public:
        TTasksContext(
                const TTopologyStorage& topologyStorage,
                const TSeenHostsUpdater& seenHostsUpdater,
                const TStaffStorage& staffStorage,
                TAgentTaskStorage& enqueuedTaskStorage,
                const TEnqueuedTaskIndex& enqueuedTaskIndex,
                const TFinishedTaskIndex& finishedTaskIndex)
            : TopologyStorage(topologyStorage)
            , SeenHostsUpdater(seenHostsUpdater)
            , StaffStorage(staffStorage)
            , EnqueuedTaskStorage(enqueuedTaskStorage)
            , EnqueuedTaskIndex(enqueuedTaskIndex)
            , FinishedTaskIndex(finishedTaskIndex)
        {
        }

        inline const TTopologyStorage& GetTopologyStorage() const noexcept {
            return TopologyStorage;
        }
        inline const TSeenHostsUpdater& GetSeenHostsUpdater() const noexcept {
            return SeenHostsUpdater;
        }
        inline const TStaffStorage& GetStaffStorage() const noexcept {
            return StaffStorage;
        }
        inline TAgentTaskStorage& GetEnqueuedTaskStorage() const noexcept {
            return EnqueuedTaskStorage;
        }
        inline const TEnqueuedTaskIndex& GetEnqueuedTaskIndex() const noexcept {
            return EnqueuedTaskIndex;
        }
        inline const TFinishedTaskIndex& GetFinishedTaskIndex() const noexcept {
            return FinishedTaskIndex;
        }

    private:
        const TTopologyStorage& TopologyStorage;
        const TSeenHostsUpdater& SeenHostsUpdater;
        const TStaffStorage& StaffStorage;
        TAgentTaskStorage& EnqueuedTaskStorage;
        const TEnqueuedTaskIndex& EnqueuedTaskIndex;
        const TFinishedTaskIndex& FinishedTaskIndex;
    };

    using TBaseTasksReply = TAuthorizedJsonHttpReply<TTasksContext>;

    class TEnqueueTaskReply: public TBaseTasksReply {
    public:
        using TBaseTasksReply::TBaseTasksReply;

        NThreading::TFuture<void> Process();

    private:
        NClient::TEnqueuedTask CreateTask(const NJson::TJsonValue& request);
        NThreading::TFuture<void> SpawnTask(const NClient::TEnqueuedTask& task);
    };

    class TFetchTaskReply: public TBaseTasksReply {
    public:
        using TBaseTasksReply::TBaseTasksReply;

        NThreading::TFuture<void> Process();

    private:
        bool FetchTask(const NJson::TJsonValue& request);
    };

    using TEnqueueTaskHandler = THttpHandler<TEnqueueTaskReply>;
    using TFetchTaskHandler = THttpHandler<TFetchTaskReply>;
}
