#!/usr/bin/env python
# pylint: disable=line-too-long,missing-docstring
from __future__ import absolute_import, print_function

import tempfile
import subprocess
import json
import os
import requests
import argparse


def sandbox(method, path, **kwargs):
    url = "https://sandbox.yandex-team.ru{}".format(path)
    resp = requests.request(method, url, data=json.dumps(kwargs), headers={
        "Authorization": "OAuth {}".format(os.environ["SANDBOX_OAUTH_TOKEN"]),
        "Content-Type": "application/json"
    })
    if not resp.ok:
        print("query sandbox: (%s %s %s) failed: %d %s" % (method, url, kwargs, resp.status_code, resp.content))
        raise Exception("Sandbox error")
    return resp.json() if resp.content else None


def start_task(target_name, task_name, context):
    task_id = sandbox("POST", "/api/v1.0/task", type=task_name, context=context)["id"]
    print("Task URL for {} is https://sandbox.yandex-team.ru/task/{}/view".format(target_name, task_id))

    sandbox("PUT", "/api/v1.0/task/{}".format(task_id), owner="RTC_INFRA", priority={
        "class": "USER",
        "subclass": "NORMAL"
    })

    print("Task started: {}".format(sandbox(
        "PUT", "/api/v1.0/batch/tasks/start", comment="build build_topology", id=[task_id])))


def main():
    data = subprocess.check_output(
        "cd $ARCADIA_ROOT && $ARCADIA_ROOT/ya svn --detect diff --diff-cmd=diff infra/netmon/build_topology", shell=True)
    task_args =  ["YA_MAKE", {
            "arts":  "infra/netmon/build_topology",
            "checkout_arcadia_from_url": "arcadia:/arc/trunk/arcadia",
            "arcadia_patch": data,
            "use_aapi_fuse": True,
            "targets": "infra/netmon",
            "result_rt": "ARCADIA_PROJECT",
            "result_rd": "build_topology_binary",
        }]

    start_task("build_topology", *task_args)


if __name__ == "__main__":
   main()
