#!/usr/bin/env python2
# -*- coding: utf-8 -*-
from __future__ import absolute_import, print_function, unicode_literals

import gzip
import argparse
import logging
import msgpack
import json


from infra.netmon.build_topology.lib.build_topology import build_topology


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("-i", "--in", default=None, dest="input",
                        help="dump input topology to human readable json or dump input json to topology")
    parser.add_argument("-o", "--out", nargs="?", default="topology.msgpack.gz", dest="destination",
                        help="target file, %(default)s by default")
    parser.add_argument("-l", "--logfile", nargs="?", default="",
                        help="log file, console log by default")
    parser.add_argument("-d", "--debug", action="store_true", help="be more verbose")
    options, cli_options_list = parser.parse_known_args()

    logging.basicConfig(
        level=logging.DEBUG if options.debug else logging.WARNING,
        filename=options.logfile or None,
        format='%(asctime)s:%(levelname)s:%(message)s',
        datefmt='%Y-%m-%dT%H:%M:%S'
    )

    hosts = []

    if options.input is not None:
        if options.input.endswith("gz"):
            with gzip.open(options.input, "rb") as stream:
                unpacker = msgpack.Unpacker(stream, raw=False)
                for host in unpacker:
                    hosts.append(host)
            print(json.dumps(hosts, sort_keys=True, indent=4))
            return
        elif options.input.endswith("json"):
            with open(options.input, "rb") as stream:
                hosts = json.load(stream)

    if not hosts:
        hosts = build_topology()
    with gzip.open(options.destination, "wb") as stream:
        for host in hosts:
            stream.write(msgpack.packb(host))


if __name__ == "__main__":
    main()
