#pragma once

#include <util/generic/string.h>

namespace NNetmon {
    class TLexer {
    public:
        enum EToken {
            Undefined = 0,
            End,

            /* values */
            True,
            False,
            Integer,
            String,
            GroupValue,

            /* operators */
            Assign,
            Invert,
            And,
            Or,
            Substract,
            LeftBracket,
            RightBracket,

            /* keywords */
            Group,
            VLAN,
            VRF,
            Virtual,
            Datacenter,
            Queue,
            Switch,
            Nanny,
            Gencfg,
            WalleProject,
            WalleTag,
            Direction
        };

        struct TTokenValue {
            EToken TokenType;
            TString Value;
        };

        TLexer(const TString& text);

        TTokenValue GetNextToken();
        TTokenValue GetCurrentToken() const {
            return LastToken;
        }

    private:
        TString Text;
        TTokenValue LastToken;

    private:
        /* Ragel related */
        int cs;
        int act;
        char* ts;
        char* te;
        char* p;
        char* pe;
        char* eof;
    };
}
